/*
 * Decompiled with CFR 0.152.
 */
package ags.ui.gameSelector;

import ags.ui.FrameBasedWidget;
import ags.ui.IApplication;
import java.util.Arrays;
import java.util.List;

public class SelectWidget
extends FrameBasedWidget {
    List<String> options;
    int currentOption = 0;

    public SelectWidget(IApplication app) {
        super(app);
        this.setYSize(1);
    }

    public boolean handleKeypress(byte b) {
        switch (b) {
            case 8: 
            case 11: {
                this.currentOption = Math.max(0, this.currentOption - 1);
                return true;
            }
            case 10: 
            case 21: {
                this.currentOption = Math.min(this.options.size() - 1, this.currentOption + 1);
                return true;
            }
        }
        return false;
    }

    public void setCurrentOption(String value) {
        this.currentOption = Math.max(0, this.options.indexOf(value));
    }

    public String getCurrentOption() {
        return this.options.get(this.currentOption);
    }

    public void setOptions(String ... options) {
        this.options = Arrays.asList(options);
        int max = 0;
        for (String o : options) {
            if (o.length() <= max) continue;
            max = o.length();
        }
        this.setXSize(max);
    }

    public void setActive(boolean active) {
        if (active) {
            this.setYSize(this.options.size());
        } else {
            this.setYSize(1);
        }
        super.setActive(active);
    }

    public void redrawInside() {
        if (this.isActive()) {
            for (int i = 0; i < this.options.size(); ++i) {
                this.app.getScreen().drawText(this.getX(), this.getY() + i, this.options.get(i), this.currentOption == i);
            }
        } else {
            this.app.getScreen().drawText(this.getX(), this.getY(), this.options.get(this.currentOption), true);
        }
    }
}

